% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{search_contracts}
\alias{search_contracts}
\title{Search contract}
\usage{
search_contracts(query, token = Sys.getenv("HLIDAC_TOKEN"), page = 1, sort = 0)
}
\arguments{
\item{query}{Full-text search query}

\item{token}{Access token}

\item{page}{Page of results}

\item{sort}{Ordering of the results, the available options are the following:
- 0: sort by relevance
- 1: recently added contracts first
- 2: recently added contracts last
- 3: the cheapest contracts first
- 4: the most expensive contracts first
- 5: recently concluded contracts first
- 6: recently concluded contracts last
- 7: the most defective contracts first
- 8: sort by purchaser
- 9: sort by supplier}
}
\value{
list containing 3 elements:
- Total: Total number of datasets available (integer)
- Page: Page of the result (integer)
- Results: Data.frame with data concerning the datasets
}
\description{
Search contract
}
\examples{
\dontrun{
search_contracts(query = "golf")
}
}
\seealso{
\url{https://www.hlidacstatu.cz/api/v2/swagger/index}

\url{https://www.hlidacstatu.cz/api/v1/doc}

\url{https://www.hlidacstatu.cz/napoveda}

\url{https://smlouvy.gov.cz/}
}
\concept{Contracts}
