% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{analyze_diagnostic}
\alias{analyze_diagnostic}
\title{Diagnostic Analysis for Emulators}
\usage{
analyze_diagnostic(
  in_data,
  output_name,
  targets = NULL,
  plt = interactive(),
  cutoff = 3,
  target_viz = NULL,
  ...
)
}
\arguments{
\item{in_data}{The data to perform the analysis on}

\item{output_name}{The name of the output emulated}

\item{targets}{If required or desired, the targets for the system outputs}

\item{plt}{Whether or not to plot the analysis}

\item{cutoff}{The implausibility cutoff for diagnostic `ce'}

\item{target_viz}{How to show the targets on the diagnostic plots}

\item{...}{Any other parameters to pass to subfunctions}
}
\value{
A data.frame of failed points
}
\description{
Produces summary and plots for diagnostics
}
\details{
Given diagnostic information (almost certainly provided from \code{\link{get_diagnostic}}),
we can plot the results and highlight the points that are worthy of concern or further
consideration. Each diagnostic available has a plot associated with it which can be produced
here:

Standardized Error: A histogram of standardized errors. Outliers should be considered, as well
as whether very many points have either large or small errors.

Comparison Diagnostics: Error bars around points, corresponding to emulator prediction plus or
minus emulator uncertainty. A green line indicates where the emulator and simulator prediction
would be in complete agreement: error bars that do not overlap with this line (coloured red) are
to be considered. Where targets are provided, the colouration is limited only to points where
the simulator prediction would be close to the targets.

Classification Error: A point plot comparing emulator implausibility to simulator
implausibility, sectioned into regions horizontally and vertically by \code{cutoff}. Points
that lie in the lower right quadrant (i.e. emulator would reject; simulator would not) should
be considered.

This function takes a data.frame that contains the input points, simulator values and, depending
on the diagnostic, a set of summary measures. It returns a data.frame of any points that failed
the diagnostic.

We may also superimpose the target bounds on the comparison diagnostics, to get a sense of
where it is most important that the emulator and simulator agree. The \code{target_viz}
argument controls this, and has three options: 'interval' (a horizontal interval); 'solid'
(a solid grey box whose dimensions match the target region in both vertical and horizontal
extent); and 'hatched' (similar to solid, but a semi-transparent box with hatching inside).
Any such vizualisation has extent equal to the target plus/mius 4.5 times the target
uncertainty. By default, \code{target_viz = NULL}, indicating that no superposition is shown.
}
\references{
Jackson (2018) <http://etheses.dur.ac.uk/12826>
}
\seealso{
\code{\link{get_diagnostic}}

Other diagnostic functions: 
\code{\link{classification_diag}()},
\code{\link{comparison_diag}()},
\code{\link{get_diagnostic}()},
\code{\link{individual_errors}()},
\code{\link{residual_diag}()},
\code{\link{standard_errors}()},
\code{\link{summary_diag}()},
\code{\link{validation_diagnostics}()}
}
\concept{diagnostic functions}
