% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{output_plot}
\alias{output_plot}
\title{Emulator Expectation Against Target Outputs}
\usage{
output_plot(ems, targets, points = NULL, npoints = 1000)
}
\arguments{
\item{ems}{The \code{\link{Emulator}} objects.}

\item{targets}{A named list of observations, given in the usual form.}

\item{points}{A list of points at which the emulators should be evaluated.}

\item{npoints}{If no points are provided, the number of input points to evaluate at.}
}
\value{
A ggplot object
}
\description{
Plots emulator expectation across the parameter space, with comparison to the corresponding
target values (with appropriate uncertainty).
}
\details{
If a \code{points} data.frame is not provided, then points are sampled uniformly from the
input region. Otherwise, the provided points are used: for example, if a representative
sample of the current NROY space is available.
}
\examples{
 output_plot(SIREmulators$ems, SIREmulators$targets)
 output_plot(SIREmulators$ems, SIREmulators$targets, points = SIRSample$training)
}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{hit_by_wave}()},
\code{\link{plot_actives}()},
\code{\link{plot_lattice}()},
\code{\link{plot_wrap}()},
\code{\link{simulator_plot}()},
\code{\link{space_removed}()},
\code{\link{validation_pairs}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
