% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_imp_semicont_multi_2017-04-11.R
\name{imp_semicont_multi}
\alias{imp_semicont_multi}
\title{The function for hierarchical imputation of semicontinuous variables.}
\usage{
imp_semicont_multi(y_imp, X_imp, Z_imp, clID, heap = 0, nitt = 3000,
  thin = 10, burnin = 1000)
}
\arguments{
\item{y_imp}{A Vector with the variable to impute.}

\item{X_imp}{A data.frame with the fixed effects variables.}

\item{Z_imp}{A data.frame with the random effects variables.}

\item{clID}{A vector with the cluster ID.}

\item{heap}{A numeric saying to which (single) values the data might be heaped.}

\item{nitt}{An integer defining number of MCMC iterations (see MCMCglmm).}

\item{thin}{An integer defining the thinning interval (see MCMCglmm).}

\item{burnin}{An integer defining the percentage of draws from the gibbs sampler
that should be discarded as burn in (see MCMCglmm).}
}
\value{
A n x 1 data.frame with the original and imputed values.
}
\description{
The function is called by the wrapper. We consider data to be "semicontinuous" when
more than 5\% of the (non categorical) observations.\cr
For example in surveys a certain portion of people, when asked for their income,
report "0", which clearly violates the assumption of income to be (log-) normally distributed.
}
