\name{dccs_boot_LR}
\alias{dccs_boot_LR}
\docType{data}
\title{
  dccs boot LR
}
\description{
  Example of a parametric bootstrap for model selection with the dccs data
}
\usage{data("dccs_boot_LR")}
\format{
  A \code{boot} object
}
\details{
  The bootstrap sample was generated by the following code:
    
    \preformatted{require(depmixS4)
      require(hmmr)
      require(boot)
      
      data(dccs)
      m2 <- mix(response=cbind(nCorPost,6-nCorPost)~1,nstates=2,
                data=dccs,family=binomial())
      set.seed(1234)
      fm2 <- fit(m2)
      set.seed(1234)
      fm3 <- fit(mix(response=cbind(nCorPost,6-nCorPost)~1, 
                     nstates=3, data=dccs,family=binomial()))
      
      boot.fun <- function(model) {
        ok <- FALSE
        while(!ok) {
          bootdat <- data.frame(
            simulate(model)@response[[1]][[1]]@y)
          fboot2 <- try({
            mod <- mix(cbind(X1,X2)~1, nstates=2, 
                       family=binomial(), data=bootdat)
            mod <- setpars(mod,getpars(fm2))
            fit(mod,emcontrol=em.control(random.start=FALSE),
                verbose=FALSE)
          })
          fboot3 <- try({
            mod <- mix(cbind(X1,X2)~1, nstates=3, 
                       family=binomial(), data=bootdat)
            mod <- setpars(mod,getpars(fm3))
            fit(mod,emcontrol=em.control(random.start=FALSE),
                verbose=FALSE)
          })
          if(!inherits(fboot2,"try-error") && 
             !inherits(fboot3,"try-error") &&
             logLik(fboot3) >= logLik(fboot2)) ok <- TRUE
          # if(ok) if(logLik(fboot3) < logLik(fboot2)) ok <- FALSE
        }  
        llratio(fboot3,fboot2)@value
      }
      set.seed(1234)
      dccs_boot_LR <- boot(fm2, boot.fun, R=10000, sim="parametric")
    }
}
\examples{
  data(dccs_boot_LR)
}
\keyword{datasets}
