% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{active_coefficients}
\alias{active_coefficients}
\alias{acoef}
\title{Obtain all Active Coefficients}
\usage{
active_coefficients(object, ...)

acoef(object, ...)
}
\arguments{
\item{object}{an object inheriting from \code{"hglm"} or \code{"hglm.fit"}
from which the active coefficients obtained from.}

\item{...}{optional arguments currently ignored.}
}
\value{
a logical vector giving the active coefficients.
}
\description{
The function returns a logical vector which is \code{TRUE} for all
active (i.e., non-zero) coefficients in the fitted model and \code{FALSE} otherwise.
}
\examples{
dat <- rhglm(100, c(1, 2, -3, 4, 5, -6))
fit <- hglm(y ~ ., constraints = k_max(3), data = dat)
active_coefficients(fit)
}
