% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{coef.hglm}
\alias{coef.hglm}
\title{Extract Model Coefficients}
\usage{
\method{coef}{hglm}(object, type = c("unscaled", "scaled", "selected"), ...)
}
\arguments{
\item{object}{an object inheriting from \code{"hglm"} or \code{"hglm.fit"}
from which the coefficients are obtained from.}

\item{type}{Default value is \code{"unscaled"}. Allowed values are
\code{"unscaled"}, \code{"scaled"} and \code{"selected"}.}

\item{...}{optional arguments currently ignored.}
}
\value{
a vector containing the unscaled, scaled or selected coefficients.
}
\description{
The function returns different types of coefficients for a model.
}
\details{
The types \code{"scaled"} and \code{"unscaled"} refer to the coefficients
 of the scaled/unscaled optimization problem. Type \code{"selected"} refers
 to the active coefficients in the model \code{\link{active_coefficients}}.
}
\examples{
dat <- rhglm(1000, 1:3)
fit <- hglm(y ~ ., data = dat)
coef(fit)
coef(fit, type="scaled")
coef(fit, type="selected")
}
