% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.HorseRulemodel}
\alias{predict.HorseRulemodel}
\title{predict.hs}
\usage{
\method{predict}{HorseRulemodel}(object, newdata, burnin = 100,
  postmean = TRUE, ...)
}
\arguments{
\item{object}{list containing a model of class "hs_rulefit".}

\item{newdata}{Dataframe containing the unseen data to predict.}

\item{burnin}{Number of samples that is disregarded as burnin. Increase number in case of slow convergence.}

\item{postmean}{If true returns the Predictive-Posterior mean value. If False returns the full predictive posterior distribution.}

\item{...}{additional arguments}
}
\value{
Returns the predictive posterior distribution matrix. Column i contains the predictive posterior of observation i.
}
\description{
Predict unseen data with the horseshoe model.
}
\examples{
x = matrix(rnorm(1000), ncol=10)
y = apply(x,1,function(x)sum(x[1:5])+rnorm(1))
hrresmod = HorseRuleFit(X=x, y=y, niter=100, burnin=10)
#predict training data to obtain the fitted values
predict(hrresmod, x, burnin=10)
}
