% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAccuracy.R
\name{calcAccuracy}
\alias{calcAccuracy}
\title{Calculate the accuracy of an index}
\usage{
calcAccuracy(hpi_obj, test_method = "insample", test_type = "rt",
  pred_df = NULL, smooth = FALSE, in_place = FALSE,
  in_place_name = "accuracy", ...)
}
\arguments{
\item{hpi_obj}{Object of class 'hpi'}

\item{test_method}{default = 'insample'; Also 'kfold'}

\item{test_type}{default = 'rt'; Type of data to use for test.  See details.}

\item{pred_df}{default = NULL; Extra data if the test_type doesn't match data in hpi_obj}

\item{smooth}{default = FALSE; calculated on the smoothed index(es)}

\item{in_place}{default = FALSE; Should the result be returned into an existing `hpi` object}

\item{in_place_name}{default = 'accuracy'; Name for returning in place}

\item{...}{Additional Arguments}
}
\value{
object of class `hpiaccuracy` inheriting from class `data.frame` containing
the following fields:
\describe{
  \item{prop_id}{Property Identification number}
  \item{price}{Transaction Price}
  \item{pred_price}{Predicted price}
  \item{error}{(Prediction - Actual) / Actual}
  \item{log_error}{log(prediction) - log(actual)}
  \item{pred_period}{Period of the prediction}
}
}
\description{
Estimate index accuracy using one of a variety of approaches
}
\section{Further Details}{

'rt' test type tests the ability of the index to correctly predict the second value in
a repeat transaction pair
FUTURE: 'hed' test type tests the ability of the index to improve an OLS model that
doesn't account for time.
(This approach is not ready yet).
}

\examples{

 # Load Data
 data(ex_sales)

 # Create Index
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Calculate insample accuracy
 hpi_accr <- calcAccuracy(hpi_obj = rt_index,
                          test_type = 'rt',
                          test_method = 'insample')

}
