% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powercalc.R
\name{startvalue}
\alias{startvalue}
\title{Start value for estimating optimal sample size}
\usage{
startvalue(lambda, R, nfam, weights = 1)
}
\arguments{
\item{lambda}{shrinkage parameter}

\item{R}{(p x p) matrix containing theoretical correlation between SNP pairs}

\item{nfam}{number of half-sib families}

\item{weights}{vector (LEN p) of SNP-specific weights or scalar if weights
are equal for all SNPs; default value 1}
}
\value{
start value
}
\description{
Calculation of start value for estimating optimal sample size
}
\details{
Minimum sample size that exceeds residual degrees of freedom; this
  value can be used as start value in grid search for optimal sample size
}
\examples{
  ### correlation matrix (should depend on sire haplotypes)
  R <- AR1(100, rho = 0.1)
  startvalue(1200, R, 10)
}
