% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H2_pairwise.R
\name{h2_pairwise}
\alias{h2_pairwise}
\alias{h2_pairwise.default}
\alias{h2_pairwise.hstats}
\title{Pairwise Interaction Strength}
\usage{
h2_pairwise(object, ...)

\method{h2_pairwise}{default}(object, ...)

\method{h2_pairwise}{hstats}(
  object,
  normalize = TRUE,
  squared = TRUE,
  sort = TRUE,
  top_m = 15L,
  eps = 1e-08,
  plot = FALSE,
  fill = "#2b51a1",
  ...
)
}
\arguments{
\item{object}{Object of class "hstats".}

\item{...}{Further parameters passed to \code{geom_bar()}.}

\item{normalize}{Should statistics be normalized? Default is \code{TRUE}.}

\item{squared}{Should \emph{squared} statistics be returned? Default is \code{TRUE}.}

\item{sort}{Should results be sorted? Default is \code{TRUE}.
(Multioutput is sorted by row means.)}

\item{top_m}{How many rows should be shown? (\code{Inf} to show all.)}

\item{eps}{Threshold below which numerator values are set to 0.}

\item{plot}{Should results be plotted as barplot? Default is \code{FALSE}.}

\item{fill}{Color of bar (only for univariate statistics).}
}
\value{
A matrix of statistics (one row per variable, one column per prediction dimension),
or a "ggplot" object (if \code{plot = TRUE}). If no pairwise
statistics have been calculated, the function returns \code{NULL}.
}
\description{
Friedman and Popescu's statistic of pairwise interaction strength, see Details.
Set \code{plot = TRUE} to plot the results as barplot.
}
\details{
Following Friedman and Popescu (2008), if there are no interaction effects between
features \eqn{x_j} and \eqn{x_k}, their two-dimensional (centered) partial dependence
function \eqn{F_{jk}} can be written as the sum of the (centered) univariate partial
dependencies \eqn{F_j} and \eqn{F_k}, i.e.,
\deqn{
  F_{jk}(x_j, x_k) = F_j(x_j)+ F_k(x_k).
}
Correspondingly, Friedman and Popescu's statistic of pairwise
interaction strength is defined as
\deqn{
  H_{jk}^2 = \frac{A_{jk}}{\frac{1}{n} \sum_{i = 1}^n\big[\hat F_{jk}(x_{ij}, x_{ik})\big]^2},
}
where
\deqn{
  A_{jk} = \frac{1}{n} \sum_{i = 1}^n\big[\hat F_{jk}(x_{ij}, x_{ik}) - 
   \hat F_j(x_{ij}) - \hat F_k(x_{ik})\big]^2
}
(check \code{\link[=partial_dep]{partial_dep()}} for all definitions).

\strong{Remarks:}
\enumerate{
\item Remarks 1 to 5 of \code{\link[=h2_overall]{h2_overall()}} also apply here.
\item \eqn{H^2_{jk} = 0} means there are no interaction effects between \eqn{x_j}
and \eqn{x_k}. The larger the value, the more of the joint effect of the two
features comes from the interaction.
\item Since the denominator differs between variable pairs, unlike \eqn{H_j},
this test statistic is difficult to compare between variable pairs.
If both main effects are very weak, a negligible interaction can get a
high \eqn{H^2_{jk}}. Therefore, Friedman and Popescu (2008) suggests to calculate
\eqn{H^2_{jk}} only for \emph{important} variables (see "Modification" below).
}

\strong{Modification}

To be better able to compare pairwise interaction strength across variable pairs,
and to overcome the problem mentioned in the last remark, we suggest as alternative
the unnormalized test statistic on the scale of the predictions,
i.e., \eqn{\sqrt{A_{jk}}}. Set \code{normalize = FALSE} and \code{squared = FALSE} to obtain
this statistic.
Furthermore, we do pairwise calculations not for the most \emph{important} features but
rather for those features with \emph{strongest overall interactions}.
}
\section{Methods (by class)}{
\itemize{
\item \code{h2_pairwise(default)}: Default pairwise interaction strength.

\item \code{h2_pairwise(hstats)}: Pairwise interaction strength from "hstats" object.

}}
\examples{
# MODEL 1: Linear regression
fit <- lm(Sepal.Length ~ . + Petal.Width:Species, data = iris)
s <- hstats(fit, X = iris[-1])

# Proportion of joint effect coming from pairwise interaction
# (for features with strongest overall interactions)
h2_pairwise(s)

# Absolute measure as alternative
h2_pairwise(s, normalize = FALSE, squared = FALSE)

# MODEL 2: Multi-response linear regression
fit <- lm(as.matrix(iris[1:2]) ~ Petal.Length + Petal.Width * Species, data = iris)
s <- hstats(fit, X = iris[3:5], verbose = FALSE)
h2_pairwise(s, plot = TRUE)
}
\references{
Friedman, Jerome H., and Bogdan E. Popescu. \emph{"Predictive Learning via Rule Ensembles."}
The Annals of Applied Statistics 2, no. 3 (2008): 916-54.
}
\seealso{
\code{\link[=hstats]{hstats()}}, \code{\link[=h2]{h2()}}, \code{\link[=h2_overall]{h2_overall()}}, \code{\link[=h2_threeway]{h2_threeway()}}
}
