% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H2_threeway.R
\name{h2_threeway}
\alias{h2_threeway}
\alias{h2_threeway.default}
\alias{h2_threeway.hstats}
\title{Three-way Interaction Strength}
\usage{
h2_threeway(object, ...)

\method{h2_threeway}{default}(object, ...)

\method{h2_threeway}{hstats}(
  object,
  normalize = TRUE,
  squared = TRUE,
  sort = TRUE,
  zero = TRUE,
  ...
)
}
\arguments{
\item{object}{Object of class "hstats".}

\item{...}{Currently unused.}

\item{normalize}{Should statistics be normalized? Default is \code{TRUE}.}

\item{squared}{Should \emph{squared} statistics be returned? Default is \code{TRUE}.}

\item{sort}{Should results be sorted? Default is \code{TRUE}.
(Multi-output is sorted by row means.)}

\item{zero}{Should rows with all 0 be shown? Default is \code{TRUE}.}
}
\value{
An object of class "hstats_matrix" containing these elements:
\itemize{
\item \code{M}: Matrix of statistics (one column per prediction dimension), or \code{NULL}.
\item \code{SE}: Matrix with standard errors of \code{M}, or \code{NULL}.
Multiply with \code{sqrt(m_rep)} to get \emph{standard deviations} instead.
Currently, supported only for \code{\link[=perm_importance]{perm_importance()}}.
\item \code{m_rep}: The number of repetitions behind standard errors \code{SE}, or \code{NULL}.
Currently, supported only for \code{\link[=perm_importance]{perm_importance()}}.
\item \code{statistic}: Name of the function that generated the statistic.
\item \code{description}: Description of the statistic.
}
}
\description{
Friedman and Popescu's statistic of three-way interaction strength, see Details.
Use \code{plot()} to get a barplot. In \code{hstats()}, set \code{threeway_m} to a value above 2
to calculate this statistic for all feature triples of the \code{threeway_m}
features with strongest overall interaction.
}
\details{
Friedman and Popescu (2008) describe a test statistic to measure three-way
interactions: in case there are no three-way interactions between features
\eqn{x_j}, \eqn{x_k} and \eqn{x_l}, their (centered) three-dimensional partial
dependence function \eqn{F_{jkl}} can be decomposed into lower order terms:
\deqn{
  F_{jkl}(x_j, x_k, x_l) = B_{jkl} - C_{jkl}
}
with
\deqn{
  B_{jkl} = F_{jk}(x_j, x_k) + F_{jl}(x_j, x_l) + F_{kl}(x_k, x_l)
}
and
\deqn{
  C_{jkl} =  F_j(x_j) + F_k(x_k) + F_l(x_l).
}

The squared and scaled difference between the two sides of the equation leads to the statistic
\deqn{
  H_{jkl}^2 = \frac{\frac{1}{n} \sum_{i = 1}^n \big[\hat F_{jkl}(x_{ij}, x_{ik}, x_{il}) - B^{(i)}_{jkl} + C^{(i)}_{jkl}\big]^2}{\frac{1}{n} \sum_{i = 1}^n \hat F_{jkl}(x_{ij}, x_{ik}, x_{il})^2},
}
where
\deqn{
  B^{(i)}_{jkl} = \hat F_{jk}(x_{ij}, x_{ik}) + \hat F_{jl}(x_{ij}, x_{il}) + 
  \hat F_{kl}(x_{ik}, x_{il})
}
and
\deqn{
  C^{(i)}_{jkl} = \hat F_j(x_{ij}) + \hat F_k(x_{ik}) + \hat F_l(x_{il}).
}
Similar remarks as for \code{\link[=h2_pairwise]{h2_pairwise()}} apply.
}
\section{Methods (by class)}{
\itemize{
\item \code{h2_threeway(default)}: Default pairwise interaction strength.

\item \code{h2_threeway(hstats)}: Pairwise interaction strength from "hstats" object.

}}
\examples{
# MODEL 1: Linear regression
fit <- lm(uptake ~ Type * Treatment * conc, data = CO2)
s <- hstats(fit, X = CO2[2:4], threeway_m = 5)
h2_threeway(s)

#' MODEL 2: Multivariate output (taking just twice the same response as example)
fit <- lm(cbind(up = uptake, up2 = 2 * uptake) ~ Type * Treatment * conc, data = CO2)
s <- hstats(fit, X = CO2[2:4], threeway_m = 5)
h2_threeway(s)
h2_threeway(s, normalize = FALSE, squared = FALSE)  # Unnormalized H
plot(h2_threeway(s))
}
\references{
Friedman, Jerome H., and Bogdan E. Popescu. \emph{"Predictive Learning via Rule Ensembles."}
The Annals of Applied Statistics 2, no. 3 (2008): 916-54.
}
\seealso{
\code{\link[=hstats]{hstats()}}, \code{\link[=h2]{h2()}}, \code{\link[=h2_overall]{h2_overall()}}, \code{\link[=h2_pairwise]{h2_pairwise()}}
}
