% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hte_match.R
\name{hte_match}
\alias{hte_match}
\title{Estimate Heterogeneous Treatment Effect via Adjusted Causal Tree}
\usage{
hte_match(
  outcomevariable,
  minsize = 20,
  crossvalidation = 20,
  data,
  treatment_indicator,
  ps_indicator,
  ps_linear = NULL,
  covariates,
  negative = FALSE,
  drawplot = TRUE,
  con.num = 1,
  varlabel = NULL,
  maintitle = "Heterogeneous Treatment Effect Estimation",
  legend.x = 0.08,
  legend.y = 0.25,
  check = FALSE,
  ...
)
}
\arguments{
\item{outcomevariable}{a character representing the column name
of the outcome variable.}

\item{minsize}{the minimum number of observations in each leaf.
The default is set as 20.}

\item{crossvalidation}{number of cross validations. The default
is set as 20.}

\item{data}{a data frame containing the variables in the model.}

\item{treatment_indicator}{a character representing the column
name of the treatment indicator.}

\item{ps_indicator}{a character representing the column name of
the propensity score.}

\item{ps_linear}{a character representing name  of  a  column  that
stores linearized  propensity scores.}

\item{covariates}{a vector of column names of all
covariates (linear terms andpropensity score).}

\item{negative}{a logical value indicating whether we expect the
treatment effect to be negative. The default is set as FALSE.}

\item{drawplot}{a logical value indicating whether to plot the
model as part of the output. The default is set as TRUE.}

\item{con.num}{a number indicating the number of units from control
groups to be used in matching.}

\item{varlabel}{a named vector containing variable labels.}

\item{maintitle}{a character string indicating the main title displayed
when plotting the tree and results. The default is set as
"Heterogeneous Treatment Effect Estimation".}

\item{legend.x, legend.y}{x and y coordinate to position the legend.
The default is set as (0.08, 0.25).}

\item{check}{if TRUE, generates 100 trees and outputs most common
tree structures and their frequency}

\item{...}{further arguments passed to or from other methods.}
}
\value{
predicted treatment effect and the associated tree
}
\description{
Estimate heterogeneous treatment effect via adjusted causal tree.
In each leaf, the treatment effect estimated from nn matching.
}
\examples{
library(rpart)
library(htetree)
hte_match(outcomevariable="outcome",
data=data.frame("x1"=c(0, 1, 1, 0, 1, 1),"x2"=c(3, 2, 1, 5, 7, 1),
"treatment"=c(0,0,0,1,1,1), "prop_score"=c(0.4, 0.4, 0.5, 0.6, 0.6, 0.7),
"outcome"=c(1, 2, 2, 1, 4, 4)), treatment_indicator = "treatment",
ps_indicator = "prop_score", covariates = c("x1","x2"))
}
