% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causalTee.control.R
\name{causalTree.control}
\alias{causalTree.control}
\title{Intermediate function for \code{causalTree}}
\usage{
causalTree.control(
  minsplit = 20L,
  minbucket = round(minsplit/3),
  cp = 0,
  maxcompete = 4L,
  maxsurrogate = 5L,
  usesurrogate = 2L,
  xval = 10L,
  surrogatestyle = 0L,
  maxdepth = 30L,
  ...
)
}
\arguments{
\item{minsplit}{minimum number of splits}

\item{minbucket}{minimum number of bucket}

\item{cp}{default is 0}

\item{maxcompete}{maximum number of compete}

\item{maxsurrogate}{maximum number of surrogate}

\item{usesurrogate}{initial number of surrogate}

\item{xval}{cross-validation}

\item{surrogatestyle}{the style of surrogate}

\item{maxdepth}{Maximum depth}

\item{...}{arguments to \code{rpart.control} may also be
specified in the call to \code{causalTree}.  They are checked against the
list of valid arguments.  An example of a commonly set parameter would
be \code{xval}, which sets the number of cross-validation samples.
The parameter \code{minsize} is implemented differently in
\code{causalTree} than in \code{rpart}; we require a minimum of \code{minsize}
treated observations and a minimum of \code{minsize} control
observations in each leaf.}
}
\value{
parameters used to in \code{causalTree}
}
\description{
Intermediate function for \code{causalTree}
}
