% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_exp_hts.R
\name{d_exp_hts}
\alias{d_exp_hts}
\title{Extraction of a time-series from htsr data base}
\usage{
d_exp_hts(fsq, sta, sen, rtime = FALSE, dstart = NA, dend = NA, rplot = FALSE)
}
\arguments{
\item{fsq}{character, Full name of the data base}

\item{sta}{character, Station id.}

\item{sen}{character, Sensor id.}

\item{rtime}{logical, Reduce time interval (default = FALSE)}

\item{dstart}{character, Start date "YYYY-MM-DD" (default=NA)}

\item{dend}{character, End date "YYYY-MM-DD" (default: NA)}

\item{rplot}{logical Plot the extracted file (default = FALSE)}
}
\value{
The function returns:
\itemize{
\item a tibble tstab with 4 columns Date, Value, Station, Sensor
\item a file (nomfic) with the following name:
<sensor.id>_<station.id>.hts}
}
\description{
The function extracts a time-series in the "hts" format. It products a "tibble"
table with four columns : Date, Value, Station, Sensor. It is the default format of the package.
The function \code{\link{f_convert}} converts it in Excel or csv format.
}
\details{
For a step by step operation the function \code{\link{ds_exp_hts}} is more convenient.
}
\examples{
\dontrun{

f <- d_exp_hts("foo.sqlite","station","sensor")


}

}
\seealso{
\code{\link{ds_exp_hts}} manual settings of the parameters
}
\author{
P. Chevallier - oct 2017 - aug 2023
}
