% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{well_param}
\alias{well_param}
\title{Microtiter Plate Well Descriptions for Armitage et al. (2014) Model}
\format{
A data frame / data table with 11 rows and 8 variables:
\describe{
  \item{sysID}{Identifier for each multi-well plate system}
  \item{well_desc}{Well description}
  \item{well_number}{Number of wells on plate}
  \item{area_bottom}{Area of well bottom in mm^2}
  \item{cell_yield}{Number of cells}
  \item{diam}{Diameter of well in mm}
  \item{v_total}{Total volume of well in uL)}
  \item{v_working}{Working volume of well in uL}
}
}
\source{
\url{https://www.corning.com/catalog/cls/documents/application-notes/CLS-AN-209.pdf}
}
\usage{
well_param
}
\description{
Microtiter Plate Well Descriptions for Armitage et al. (2014) model from
Honda et al. (2019)
}
\references{
Armitage, J. M.; Wania, F.; Arnot, J. A. Environ. Sci. Technol.
2014, 48, 9770-9779. dx.doi.org/10.1021/es501955g

Honda, Gregory S., et al. "Using the Concordance of In Vitro and
In Vivo Data to Evaluate Extrapolation Assumptions", PloS ONE 14.5 (2019): e0217564.
}
\author{
Greg Honda
}
\keyword{data}
