% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_chemtable.R
\name{CAS.checksum}
\alias{CAS.checksum}
\title{Test the check digit of a CAS number to confirm validity}
\usage{
CAS.checksum(CAS.string)
}
\arguments{
\item{CAS.string}{A character string of three numbers separated by two dashes}
}
\value{
logical (TRUE if final digit of CAS is consistent with other digits)
}
\description{
Chemical abstracts services registry numbers (CAS-RN) include a final digit
as a "checksum" to test for validity (that is, that the number has not been
corrupted).
}
\details{
The check digit (final number) is calculated by working from right to left,
starting with the second to last digit of the CAS-RN. We multiply each digit
by an increasing digit (1, 2, 3...) and sum as we work from right to left.
The check digit should equal the final digit of the sum.
}
\author{
John Wambaugh
}
