% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-request.R
\name{expect-verb}
\alias{expect-verb}
\alias{expect_GET}
\alias{expect_POST}
\alias{expect_PUT}
\alias{expect_PATCH}
\alias{expect_DELETE}
\alias{expect_no_request}
\alias{expect_POST}
\alias{expect_PATCH}
\alias{expect_PUT}
\alias{expect_DELETE}
\alias{expect_no_request}
\title{Expecations for mocked HTTP requests}
\usage{
expect_GET(object, url = "", ...)

expect_POST(object, url = "", ...)

expect_PATCH(object, url = "", ...)

expect_PUT(object, url = "", ...)

expect_DELETE(object, url = "")

expect_no_request(object, ...)
}
\arguments{
\item{object}{Code to execute that may cause an HTTP request}

\item{url}{character: the URL you expect a request to be made to. Default is
an empty string, meaning that you can just assert that a request is made with
a certain method without asserting anything further.}

\item{...}{character segments of a request payload you expect to be included
in the request body, to be joined together by \code{paste0}}
}
\value{
A \code{testthat} 'expectation'.
}
\description{
The mock contexts in \code{httptest} can raise errors or messages when requests
are made, and those (error) messages have three
elements, separated by space: (1) the request
method (e.g. "GET"); (2) the request URL; and
(3) the request body, if present.
These verb-expectation functions look for this message shape. \code{expect_PUT},
for instance, looks for a request message that starts with "PUT".
}
\examples{
library(httr)
without_internet({
    expect_GET(GET("http://httpbin.org/get"),
        "http://httpbin.org/get")
    expect_PUT(PUT("http://httpbin.org/put", body='{"a":1}'),
        'http://httpbin.org/put',
        '{"a":1}')
    expect_PUT(PUT("http://httpbin.org/put", body='{"a":1}'))
    expect_no_request(rnorm(5))
})
}
