% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-server-side.R
\name{jwt_signature}
\alias{jwt_signature}
\title{Generate a JWT signature given credentials.}
\usage{
jwt_signature(credentials, scope, aud, duration = 60L * 60L)
}
\arguments{
\item{credentials}{Parsed contents of the credentials file.}

\item{scope}{A space-delimited list of the permissions that the application
requests.}

\item{duration}{Duration of token, in seconds.}
}
\description{
As described in
\url{https://developers.google.com/accounts/docs/OAuth2ServiceAccount}
}
\examples{
\dontrun{
cred <- jsonlite::fromJSON("~/Desktop/httrtest-45693cbfac92.json")
jwt_signature(cred, "https://www.googleapis.com/auth/userinfo.profile")
}
}
\keyword{internal}

