% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/last.R
\name{last_response}
\alias{last_response}
\alias{last_request}
\alias{last_request_json}
\alias{last_response_json}
\title{Retrieve most recent request/response}
\usage{
last_response()

last_request()

last_request_json(pretty = TRUE)

last_response_json(pretty = TRUE)
}
\arguments{
\item{pretty}{Should the JSON be pretty-printed?}
}
\value{
\code{last_request()} and \code{last_response()} return an HTTP
\link{request} or \link{response} respectively. If no request has been made,
\code{last_request()} will return \code{NULL}; if no request has been made
or the last request was unsuccessful, \code{last_response()} will return
\code{NULL}.

\code{last_request_json()} and \code{last_response_json()} always return a string.
They will error if \code{last_request()} or \code{last_response()} are \code{NULL} or
don't have JSON bodies.
}
\description{
\code{last_request()} and \code{last_response()} retrieve the most recent request
made by httr2 and the response it received, to facilitate debugging problems
\emph{after} they occur.

\code{last_request_json()} and \code{last_response_json()} return the JSON bodies of
the most recent request and response. They will error if not JSON.
}
\examples{
. <- request("http://httr2.r-lib.org") |> req_perform()
last_request()
last_response()

. <- request(example_url("/post")) |>
  req_body_json(list(a = 1, b = 2)) |>
  req_perform()
last_request_json()
last_request_json(pretty = FALSE)
last_response_json()
last_response_json(pretty = FALSE)
}
