% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp-timing.R
\name{resp_timing}
\alias{resp_timing}
\title{Extract timing data}
\usage{
resp_timing(resp)
}
\arguments{
\item{resp}{A httr2 \link{response} object, created by \code{\link[=req_perform]{req_perform()}}.}
}
\value{
Named numeric vector of timing information.
The names of the elements in this vector correspond to the names used
in \href{https://curl.se/libcurl/c/curl_easy_getinfo.html}{libcurl's \code{curl_easy_getinfo()} API}.
The most useful component is likely \code{"total"} (corresponding to
\code{CURLINFO_TOTAL_TIME}), the overall time in seconds to complete the
request including any redirects followed.
}
\description{
The underlying curl library measures how long different components of the
request take to complete. This function retrieves that information.
}
\examples{
req <- request(example_url())
resp <- req_perform(req)
resp_timing(resp)
}
