\name{huge.plot}
\alias{huge.plot}
\title{
Graph plotting function
}
\description{
A function of "huge" package to automatically organize and plot the graph using adjacency matrix.
}
\usage{
huge.plot(G, epsflag = FALSE, graph.name = "default", cur.num = 1, 
location)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{G}{
The adjaceny matrix corresponding to the graph.
}
  \item{epsflag}{
If \code{epsflag = TRUE}, save the plot as an eps file in the target directory. The default value is \code{FALSE}.
}
  \item{graph.name}{
The name of the output eps files. The default value is "default".
}
  \item{cur.num}{
The number of plots saved as eps files. Only applicale when \code{epsflag = TRUE}. The default value is 1.
}
  \item{location}{
Target directory. The default value is the current working directory.
}
}
\details{
The user can change \code{cur.num} to plot several figures and select the best one.
}
\author{
Tuo Zhao, Han Liu, Kathryn Roeder, John Lafferty, and Larry Wasserman \cr
Maintainers: Tuo Zhao<tourzhao@gmail.com>; Han Liu <hanliu@cs.jhu.edu>
}
\references{
Tuo Zhao and Han Liu. HUGE: A Package for High-dimensional Undirected Graph Estimation. Technical Report, Carnegie Mellon University, 2010
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{huge}} and \code{\link{huge-package}}
}
\examples{
#generate data
L = huge.generator()

#plot the graph
huge.plot(L$theta)

#show working directory
getwd()

#plot 5 graphs and save the plots as eps files in the working directory  
huge.plot(L$theta, epsflag = TRUE, cur.num = 5)
}