% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_storm_data.R
\name{filter_storm_data}
\alias{filter_storm_data}
\title{Filter hurricane datasets}
\usage{
filter_storm_data(counties = NULL, storm = NULL, year_range = NULL,
  distance_limit = NULL, rain_limit = NULL, include_rain = FALSE,
  days_included = NULL, output_vars = c("fips"))
}
\arguments{
\item{counties}{A character vector listing all 5-digit county FIPS codes
for a subset of counties.}

\item{storm}{A character string giving the storm ID (e.g., "Floyd-1999")}

\item{year_range}{A numeric vector of length two with the starting and
ending year to subset to.}

\item{distance_limit}{A numeric vector of length one giving the maxmimum
distance (in kilometers) to use in the filter}

\item{rain_limit}{A numeric vector of length one giving the minimum
rain (in millimeters) to use in the filter}

\item{include_rain}{A logical specifying whether to pull in rain data to use
in the filter or give as output (default is FALSE)}

\item{days_included}{A numeric vector giving the lag numbers for days to
include when calculating the total rain over the storm period (e.g.,
\code{c(-1, 0, 1, 2)} would calculate the rain from the day before the
storm until two days after the storm). Values in this vector cannot be
lower than -3 or higher than 3.}

\item{output_vars}{A character vector listing all the columns to include
in the output.}
}
\value{
A dataframe with storms filtered based on the input criteria to the
   function. Columns in the output will vary depending on the user's
   selections for the \code{output_vars} argument.
}
\description{
This function is a helper function for many of the the other functions in
this package that measure exposure.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

filter_storm_data(counties = c("22071", "51700"), year_range = c(1988, 2011),
                  distance_limit = 250, rain_limit = 150,
                 include_rain = TRUE, days_included = c(-1, 0, 1),
                 output_vars = c("fips", "storm_id", "closest_date",
                                 "storm_dist", "tot_precip"))
filter_storm_data(storm = "Floyd-1999", include_rain = TRUE,
                 days_included = c(-1, 0, 1),
                 output_vars = c("fips", "tot_precip"))
}
}
