% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huxreg.R
\name{huxreg}
\alias{huxreg}
\title{Create a huxtable to display model output}
\usage{
huxreg(..., error_style = c("stderr", "ci", "statistic", "pvalue"),
  error_pos = c("below", "same", "right"), number_format = "\%.3f",
  pad_decimal = ".", ci_level = 0.95, stars = c(`***` = 0.001, `**` =
  0.01, `*` = 0.05), bold_signif = NULL, note = "\%stars\%.",
  statistics = c(N = "nobs", R2 = "r.squared", "logLik", "AIC"),
  coefs = NULL, omit_coefs = NULL)
}
\arguments{
\item{...}{Models, or a single list of models.}

\item{error_style}{How to display uncertainty in estimates. One or more of 'stderr', 'ci' (confidence interval), 'statistic' or 'pvalue'.}

\item{error_pos}{Display uncertainty 'below', to the 'right' of, or in the 'same' cell as estimates.}

\item{number_format}{Format for numbering. See \code{\link{number_format}} for details.}

\item{pad_decimal}{Character for decimal point; columns will be right-padded to align these.
Set to \code{NA} to turn off padding. See \code{\link{pad_decimal}} for details.}

\item{ci_level}{Confidence level for intervals.}

\item{stars}{Levels for p value stars. Names of \code{stars} are symbols to use.}

\item{bold_signif}{Where p values are below this number, cells will be displayed in bold. Use \code{NULL} to turn off
this behaviour.}

\item{note}{Footnote for bottom cell, which spans all columns. \code{\%stars\%} will be replaced by a note about
significance stars. Set to \code{NULL} for no footnote.}

\item{statistics}{Summary statistics to display.}

\item{coefs}{Display only these coefficients. Overrules \code{omit_coef}.}

\item{omit_coefs}{Omit these coefficients.}
}
\value{
A huxtable object.
}
\description{
Create a huxtable to display model output
}
\details{
Models must have a \code{\link[broom]{tidy}} method defined, which should return 'term', 'estimate', 'std.error',
'statistic' and 'p.value'. If the \code{tidy} method does not have a \code{conf.int} option, \code{huxreg} will
calculate confidence intervals itself, using a normal approximation.

If \code{...} is a named list, the names will be used for column headings. If the \code{coef} and/or
 \code{statistics} vectors have names, these will be used for row headings. If different values of \code{coef}
 have the same name, the corresponding rows will be merged in the output.

Each element of \code{statistics} should be a column name from \code{\link[broom]{glance}}. You can also
use 'nobs' for the number of observations.
}
\examples{
set.seed(27101975)
dfr <- data.frame(a = rnorm(100), b = rnorm(100))
dfr$y <- dfr$a + rnorm(100)
lm1 <- lm(y ~ a, dfr)
lm2 <- lm(y ~ a + b, dfr)
glm1 <- glm(I(y > 0) ~ a, dfr, family = binomial)
huxreg(lm1, lm2, glm1)
}
