% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{left_border_color}
\alias{left_border_color}
\alias{left_border_color<-}
\alias{set_left_border_color}
\alias{left_border_color.huxtable}
\alias{left_border_color<-.huxtable}
\alias{right_border_color}
\alias{top_border_color}
\alias{bottom_border_color}
\alias{right_border_color<-}
\alias{top_border_color<-}
\alias{bottom_border_color<-}
\alias{right_border_color.huxtable}
\alias{top_border_color.huxtable}
\alias{bottom_border_color.huxtable}
\alias{right_border_color<-.huxtable}
\alias{top_border_color<-.huxtable}
\alias{bottom_border_color<-.huxtable}
\alias{set_right_border_color}
\alias{set_top_border_color}
\alias{set_bottom_border_color}
\title{Border colors}
\usage{
left_border_color(ht)
left_border_color(ht) <- value
set_left_border_color(ht, row, col, value, byrow = FALSE)

right_border_color(ht)
right_border_color(ht) <- value
set_right_border_color(ht, row, col, value, byrow = FALSE)

top_border_color(ht)
top_border_color(ht) <- value
set_top_border_color(ht, row, col, value, byrow = FALSE)

bottom_border_color(ht)
bottom_border_color(ht) <- value
set_bottom_border_color(ht, row, col, value, byrow = FALSE)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A vector or matrix of colors. Set to \code{NA} for the default. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier. See \code{\link{rowspecs}} for details.}

\item{col}{An optional column specifier.}

\item{byrow}{If \code{TRUE}, fill in values by row rather than by column.}
}
\value{
For \code{left_border_color}, the \code{left_border_color} attribute.
For \code{set_left_border_color}, the \code{ht} object.

Similarly for the other functions.
}
\description{
Functions to get or set the border colors property of huxtable table cells.
}
\details{
Both LaTeX and HTML collapse borders. If results are not what you expected, try setting the
adjoining border of the previous cell to width 0 (e.g. for a left border color, unset the right border
of the cell on the left).
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
left_border_color(ht) <-  'red'
left_border_color(ht)


ht <- huxtable(a = 1:3, b = 3:1)
set_left_border_color(ht, 'red')
set_left_border_color(ht, 1:2, 1, 'red')
set_left_border_color(ht, 1:2, 1:2, c('red', 'blue'), byrow = TRUE)
set_left_border_color(ht, where(ht == 1), 'red')
}
\seealso{
\code{\link[=set_all_border_colors]{set_all_border_colors()}}
}
