% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{bold}
\alias{bold}
\alias{bold<-}
\alias{set_bold}
\alias{map_bold}
\alias{italic}
\alias{italic<-}
\alias{set_italic}
\alias{map_italic}
\title{Cell text style}
\usage{
bold(ht)
bold(ht) <- value
set_bold(ht, row, col, value, byrow = FALSE)
map_bold(ht, row, col, fn)

italic(ht)
italic(ht) <- value
set_italic(ht, row, col, value, byrow = FALSE)
map_italic(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A logical vector or matrix. \code{TRUE} for bold/italic.

Set to \code{NA} to reset to the default, which is \code{FALSE}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{bold}, the \code{bold} property.
For \code{set_bold} and \code{map_bold}, the modified huxtable.

Similarly for \code{italic} and friends.
}
\description{
Functions to get or set the \emph{cell text style} property of huxtable cells.
}
\examples{

bold(jams) <-  TRUE
bold(jams)


set_bold(jams, TRUE)
set_bold(jams,
      2:3, 1, TRUE)
map_bold(jams,
      by_rows(TRUE, FALSE))
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{font_size}}, \code{\link{font}},
  \code{\link{na_string}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
\concept{formatting functions}
