% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex-dependencies.R
\name{report_latex_dependencies}
\alias{report_latex_dependencies}
\alias{check_latex_dependencies}
\alias{install_latex_dependencies}
\title{Tools for LaTeX dependencies}
\usage{
report_latex_dependencies(quiet = FALSE, as_string = FALSE)

check_latex_dependencies(quiet = FALSE)

install_latex_dependencies()
}
\arguments{
\item{quiet}{Logical. For \code{report_latex_dependencies}, suppress printing of dependencies.
For \code{check_latex_dependencies}, suppress messages.}

\item{as_string}{Logical: return dependencies as a string.}
}
\value{
If \code{as_string} is \code{TRUE}, \code{report_latex_dependencies} returns a string of
\code{"\\\\usepackage\\{...\\}"} statements; otherwise it returns a list of
\code{rmarkdown::latex_dependency} objects, invisibly.

\code{check_latex_dependencies()} returns \code{TRUE} or \code{FALSE}.

\code{install_latex_dependencies} returns \code{TRUE} if \code{tlmgr} returns 0.
}
\description{
\code{report_latex_dependencies} prints out and/or returns a list of LaTeX dependencies for adding
to a LaTeX preamble.

\code{check_latex_dependencies} checks whether the required LaTeX packages are installed.

\code{install_latex_dependencies} is a utility function to install the LaTeX packages
that huxtable requires. It calls \code{\link[tinytex:tlmgr_install]{tinytex::tlmgr_install()}} if possible,
or \code{tlmgr install} directly.
}
\examples{
report_latex_dependencies()

\dontrun{
  check_latex_dependencies()
}

\dontrun{
  install_latex_dependencies()
}
}
