% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{background_color}
\alias{background_color}
\alias{background_color<-}
\alias{set_background_color}
\alias{map_background_color}
\title{Set cell background color}
\usage{
background_color(ht)
background_color(ht) <- value
set_background_color(ht, row, col, value )
map_background_color(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{value}{A character vector or matrix.

Set to \code{NA} to reset to the default, which is \code{"NA"}.}
}
\value{
\code{background_color()} returns the \code{background_color} property.
\code{set_background_color()} returns the modified huxtable.
}
\description{
Colors can be in any format understood by R:
\itemize{
\item A color name like \code{"darkred"}
\item A HTML string like \code{"#FF0000"}
\item The result of a function like \code{rgb(1, 0, 0)} or \code{grey(0.5)}
}
}
\details{
Transparent colors are not guaranteed to work at present.
}
\examples{

background_color(jams) <-  grey(0.7)
background_color(jams)

set_background_color(jams, "yellow")
set_background_color(jams,
      2:3, 1, "yellow")
map_background_color(jams,
      by_rows("yellow", grey(0.7)))
}
\seealso{
Other formatting functions: 
\code{\link{bold}()},
\code{\link{font}()},
\code{\link{font_size}()},
\code{\link{na_string}()},
\code{\link{number_format}()},
\code{\link{text_color}()}
}
\concept{formatting functions}
