% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping-functions.R
\name{by_function}
\alias{by_function}
\title{Map cell contents to cell properties using a function or scale}
\usage{
by_function(inner_fn, ignore_na = TRUE)
}
\arguments{
\item{inner_fn}{A one-argument function which maps cell values to property values.}

\item{ignore_na}{If \code{TRUE}, \code{NA} values in the result will be left unchanged
from their previous values. Otherwise, \code{NA}
normally resets to the default.}
}
\value{
A function for use in \verb{map_***} functions.
}
\description{
This creates a simple wrapper around a function for use in \code{map_xxx}.
Useful functions include scales and palettes from the \code{scales} package.
}
\details{
The argument of \code{inner_fn} will be \code{as.matrix(ht[row, col])}. Be aware how matrix conversion
affects the \code{mode} of cell data.
}
\examples{
ht <- as_hux(matrix(runif(20), 5, 4))

map_background_color(ht,
      by_function(grey))

if (requireNamespace("scales")) {
  map_text_color(ht, by_function(
          scales::seq_gradient_pal()
        ))
}
}
\seealso{
\link{mapping-functions}

Other mapping functions: 
\code{\link{by_cases}()},
\code{\link{by_colorspace}()},
\code{\link{by_quantiles}()},
\code{\link{by_ranges}()},
\code{\link{by_regex}()},
\code{\link{by_rows}()},
\code{\link{by_values}()}
}
\concept{mapping functions}
