% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-table.R
\name{caption_width}
\alias{caption_width}
\alias{caption_width<-}
\alias{set_caption_width}
\title{Set the width of the table caption}
\usage{
caption_width(ht)
caption_width(ht) <- value
set_caption_width(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{Number or string. Set to \code{NA} to reset to the default, which is
\code{NA}.}
}
\value{
\code{caption_width()} returns the \code{caption_width} property.
\code{set_caption_width()} returns the modified huxtable.
}
\description{
A numeric widths is interpreted as a proportion of text width in LaTeX, or of
width of the containing element in HTML. A character width must be a valid
LaTeX or CSS dimension. The default, \code{NA}, makes the caption the same width
as the table.
}
\examples{

caption_width(jams) <-  0.5
caption_width(jams)
}
\seealso{
Other caption properties: 
\code{\link{caption}()},
\code{\link{caption_pos}()}
}
\concept{caption properties}
