% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes.R
\name{rmbayesgl}
\alias{rmbayesgl}
\title{Bayes test for random mating using genotype log-likelihoods}
\usage{
rmbayesgl(
  gl,
  method = c("stan", "gibbs"),
  lg = TRUE,
  alpha = NULL,
  beta = NULL,
  chains = 2,
  cores = 1,
  iter = 2000,
  warmup = floor(iter/2),
  ...
)
}
\arguments{
\item{gl}{A matrix of genotype log-likelihoods. The rows index the
individuals and the columns index the genotypes. So \code{gl[i,k]}
is the genotype log-likelihood for individual \code{i} at
dosage \code{k-1}. We assume the \emph{natural} log is used (base e).}

\item{method}{Should we use Stan (\code{"stan"}) or Gibbs sampling
(\code{"gibbs"})?}

\item{lg}{A logical. Should we return the log Bayes factor (\code{TRUE})
or the Bayes factor (\code{FALSE})?}

\item{alpha}{The concentration hyperparameters of the gamete frequencies
under the null of random mating. Should be length ploidy/2 + 1.}

\item{beta}{The concentration hyperparameters of the genotype frequencies
under the alternative of no random mating. Should be length ploidy + 1.}

\item{chains}{Number of MCMC chains. Almost always 1 is enough, but we
use 2 as a default to be conservative.}

\item{cores}{Number of cores to use.}

\item{iter}{Total number of iterations.}

\item{warmup}{Number of those iterations used in the burnin.}

\item{...}{Control arguments passed to \code{\link[rstan]{sampling}()}.}
}
\description{
Bayes test for random mating using genotype log-likelihoods
}
\examples{

\dontrun{
set.seed(1)
ploidy <- 4

## Simulate under the null ----
p <- stats::runif(ploidy / 2 + 1)
p <- p / sum(p)
q <- stats::convolve(p, rev(p), type = "open")

## See BF increases
nvec <- c(stats::rmultinom(n = 1, size = 10, prob = q))
gl <- simgl(nvec = nvec)
rmbayesgl(gl = gl)
rmbayesgl(gl = gl, method = "gibbs")

nvec <- c(stats::rmultinom(n = 1, size = 100, prob = q))
gl <- simgl(nvec = nvec)
rmbayesgl(gl = gl)
rmbayesgl(gl = gl, method = "gibbs")

nvec <- c(stats::rmultinom(n = 1, size = 1000, prob = q))
gl <- simgl(nvec = nvec)
rmbayesgl(gl = gl)
rmbayesgl(gl = gl, method = "gibbs")

## Simulate under the alternative ----
q <- stats::runif(ploidy + 1)
q <- q / sum(q)

## See BF decreases
nvec <- c(stats::rmultinom(n = 1, size = 10, prob = q))
gl <- simgl(nvec = nvec)
rmbayesgl(gl = gl)
rmbayesgl(gl = gl, method = "gibbs")

nvec <- c(stats::rmultinom(n = 1, size = 100, prob = q))
gl <- simgl(nvec = nvec)
rmbayesgl(gl = gl)
rmbayesgl(gl = gl, method = "gibbs")

nvec <- c(stats::rmultinom(n = 1, size = 1000, prob = q))
gl <- simgl(nvec = nvec)
rmbayesgl(gl = gl)
rmbayesgl(gl = gl, method = "gibbs")

}

}
\references{
\itemize{
\item{Gerard D (2022). "Bayesian tests for random mating in autopolyploids." \emph{bioRxiv}. \doi{10.1101/2022.08.11.503635}.}
}
}
\author{
David Gerard
}
