% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterLevelFlood2.R
\name{waterLevelFlood2}
\alias{waterLevelFlood2}
\title{Compute 1d water level data through linear interpolation with 
  neighboring gauging stations according to the INFORM 3-method Flood2
  (Flut2)}
\usage{
waterLevelFlood2(wldf)
}
\arguments{
\item{wldf}{an object of class \linkS4class{WaterLevelDataFrame}.}
}
\value{
An object of class \linkS4class{WaterLevelDataFrame}.
}
\description{
This function computes a 1d water level according to the
  \href{https://www.bafg.de/DE/08_Ref/U3/02_analyse/01_INFORM/inform.html}{INFORM}
  flood duration method Flood2 (Flut2) and stores it as column \code{w} of an
  S4 object of type \linkS4class{WaterLevelDataFrame}. Flood2 is designed to
  enable water level computation between gauging stations along waterways 
  without reference water levels, provided for example by
  \href{https://www.bafg.de/DE/08_Ref/M2/03_Fliessgewmod/01_FLYS/flys_node.html}{FLYS3}.
  The function uses neighboring gauging stations for linear interpolation of
  gauging station water levels along the selected river stretch. Here it is
  provided mainly for historical reasons and more advanced functions like 
  \code{\link{waterLevel}} or \code{\link{waterLevelPegelonline}} should be
  used.
}
\details{
This function computes a water level through simple linear
  interpolation of water levels at neighboring gauging stations. Historically
  it has been designed for rivers without 1d reference water levels provided
  by FLYS3 for \code{\link{df.flys}}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf1 <- waterLevelFlood2(wldf)
wldf1

}
\references{
\insertRef{rosenzweig_inform_2011}{hyd1d}
}
