% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag.R
\name{get_lag_file}
\alias{get_lag_file}
\title{Get Lag from Input File}
\usage{
get_lag_file(
  Q_file,
  relation_file,
  steplength = 15,
  lag.max = 20,
  na.action = na.pass,
  tz = "Etc/GMT-1",
  format = "\%Y.\%m.\%d \%H:\%M",
  cols = c(1, 2, 3),
  inputsep = ";",
  inputdec = ".",
  save = FALSE,
  outfile = file.path(tempdir(), "relation.csv"),
  mc.cores = getOption("mc.cores", 2L),
  overwrite = FALSE
)
}
\arguments{
\item{Q_file}{Data frame or character string. If it is a data
frame, it corresponds to the \code{Q} data frame in
\code{\link[=get_lag]{get_lag()}}.  It contains at least a
column with the gauging station ID (default: column index 1), a
column with date-time values in character representation
(default: column index 2) and a column with flow rates
(default: column index 3). If the column indices differ from
\code{c(1, 2, 3)}, they have to be specified as \code{cols}
argument in the format \code{c(i, j, k)}. If it is a character
string, it contains the path to the corresponding file which is
then read within the function with
\code{\link[utils:read.csv]{utils::read.csv()}}.}

\item{relation_file}{A character string containing the path to the
relation file. It is read within the function with
\code{\link[utils:read.csv]{utils::read.csv()}}.  The file must
contain a column \code{ID} that contains the gauging station
ID's in order of their location in downstream direction. The
lag will then be appended as column to the data frame. For more
details on the relation file, see the vignette.}

\item{steplength}{Numeric value that specifies the length between
time steps in minutes (default: \code{15} minutes). As time
steps have to be equispaced, this is used by
\code{\link[hydropeak:flow]{hydropeak::flow()}} to get a
compatible format and fill missing time steps with \code{NA}.}

\item{lag.max}{Maximum lag at which to calculate the ccf in
\code{\link[stats:ccf]{stats::ccf()}}.}

\item{na.action}{Function to be called to handle missing values in
\code{\link[stats:ccf]{stats::ccf()}} (default:
\code{na.pass}).}

\item{tz}{Character string specifying the time zone to be used for
internal conversion (default: \code{Etc/GMT-1}).}

\item{format}{Character string giving the date-time format of the
date-time column in the input data frame \code{Q}. This is
passed to \code{\link[hydropeak:flow]{hydropeak::flow()}}, to
get a compatible format (default: \code{YYYY.mm.dd HH:MM}).}

\item{cols}{Integer vector specifying column indices in the input
data frame which contain gauging station ID, date-time and flow
rate to be renamed. The default indices are 1 (ID), 2
(date-time) and 3 (flow rate, Q).}

\item{inputsep}{Character string for the field separator in input
data.}

\item{inputdec}{Character string for decimal points in input data.}

\item{save}{A logical. If \code{FALSE} (default) the lag, appended
to the relation file, is not written to a file, otherwise it is
written to \code{outfile}.}

\item{outfile}{A character string naming a file path where the
output file should be written to.}

\item{mc.cores}{Number of cores to use with
\code{\link[parallel:mclapply]{parallel::mclapply()}}. On
Windows, this will be set to 1.}

\item{overwrite}{A logical. If \code{FALSE} (default), it produces
an error if a \code{LAG} column already exists in the
\code{relation} file. Otherwise, it overwrites an existing
column.}
}
\value{
Returns invisible the data frame of the relation data with
    the estimated cumulative lag between neighboring gauging
    stations' lag in the format \code{HH:MM} appended.
}
\description{
Given a file path it reads a data frame (time series)
    of stage measurements which combines several ID's and calls
    \code{\link[=get_lag]{get_lag()}}. The relation (ID's) of
    gauging stations is read from a file (provide file path). Make
    sure that the file with \code{Q} data and the relation file
    have the same separator (\code{inputsep}) and character for
    decimal points (\code{inputdec}). Gauging station ID's have to
    be in order of their location in downstream direction. The
    resulting lag is appended to the relation file. This can be
    saved to a file.
}
\examples{
Q_file <- system.file("testdata", "Q.csv", package = "hydroroute")
relation_file <- system.file("testdata", "relation.csv",
                             package = "hydroroute")
get_lag_file(Q_file, relation_file, inputsep = ",", inputdec = ".",
             format = "\%Y-\%m-\%d \%H:\%M", save = FALSE, overwrite = TRUE)

Q_file <- read.csv(Q_file)
get_lag_file(Q_file, relation_file, inputsep = ",", inputdec = ".",
             format = "\%Y-\%m-\%d \%H:\%M", save = FALSE, overwrite = TRUE)
}
