% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_hm_show.R
\name{hm_show}
\alias{hm_show}
\alias{hm_show,hydromet-method}
\alias{hm_show,hydromet_station-method}
\alias{hm_show,hydromet_compact-method}
\title{Easy access to see your data}
\usage{
hm_show(obj, slot_name = "fill", show = "head")

\S4method{hm_show}{hydromet}(obj, slot_name = "fill", show = "head")

\S4method{hm_show}{hydromet_station}(obj, slot_name = "fill", show = "head")

\S4method{hm_show}{hydromet_compact}(obj, slot_name = "compact", show = "head")
}
\arguments{
\item{obj}{a valid \code{hydromet_XXX} class object.}

\item{slot_name}{string vector with the name of the slot(s) to show. Alternatively
you can use \code{'fill'} or \code{'empty'} to get the data frames with or without
data respectively.}

\item{show}{string with either \code{'head'} or \code{'tail'}.}
}
\value{
It prints the data inside the required slot.
}
\description{
This method shows the 'head' or 'tail' of a specific slot.
}
\section{Functions}{
\itemize{
\item \code{hm_show,hydromet-method}: plot method for hydromet class

\item \code{hm_show,hydromet_station-method}: plot method for station class

\item \code{hm_show,hydromet_compact-method}: plot method for compact class
}}

\examples{

# lets work with the cuevas station
path <- system.file('extdata', package = 'hydrotoolbox')

# use the build method
hm_cuevas <-
  hm_create() \%>\%
  hm_build(bureau = 'ianigla', path = path,
           file_name = 'ianigla_cuevas.csv',
           slot_name = c('tair', 'rh', 'patm',
                         'precip', 'wspd', 'wdir',
                         'kin', 'hsnow', 'tsoil'),
           by = 'hour',
           out_name = c('tair(°C)', 'rh(\%)', 'patm(mbar)',
                        'p(mm)', 'wspd(km/hr)', 'wdir(°)',
                        'kin(kW/m2)', 'hsnow(cm)', 'tsoil(°C)' )
          )

# now we want to know which are the slots with data
hm_show(obj = hm_cuevas)

# see the last values of our data
hm_show(obj = hm_cuevas, show = 'tail')

# or maybe we want to know which slot have no data
hm_show(obj = hm_cuevas, slot_name = 'empty')

# focus on specific slots
hm_show(obj = hm_cuevas, slot_name = c('kin', 'rh') )
hm_show(obj = hm_cuevas, slot_name = c('kin', 'rh'), show = 'tail' )

}
