% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_hm_subset.R
\name{hm_subset}
\alias{hm_subset}
\alias{hm_subset,hydromet_station-method}
\alias{hm_subset,hydromet_compact-method}
\title{Subset your data by dates}
\usage{
hm_subset(obj, slot_name = "all", from = NULL, to = NULL)

\S4method{hm_subset}{hydromet_station}(obj, slot_name = "all", from = NULL, to = NULL)

\S4method{hm_subset}{hydromet_compact}(obj, slot_name = "all", from = NULL, to = NULL)
}
\arguments{
\item{obj}{a valid \code{hydromet_XXX} class object.}

\item{slot_name}{string vector with the name(s) of the slot(s) to subset. If you use
'all' as argument the method will subset all the variables with data.}

\item{from}{string \code{Date} or \code{POSIX*} value with the starting date. You can
use \code{from} without \code{to}. In this case you will subset your data \code{from}
till the end.}

\item{to}{string \code{Date} or \code{POSIX*} value with the starting date. You can
use \code{to} without \code{from}. In this case you will subset your data from the
beginning till \code{to}.}
}
\value{
The same \code{hydromet_XXX} class object provided in \code{obj} but subsetted.
}
\description{
The method will subset the required slot.
}
\section{Functions}{
\itemize{
\item \code{hm_subset(hydromet_station)}: subset method for station class

\item \code{hm_subset(hydromet_compact)}: subset method for compact class

}}
\examples{
\dontrun{
# cuevas station
path <- system.file('extdata', package = 'hydrotoolbox')

# use the build method
hm_cuevas <-
  hm_create() \%>\%
  hm_build(bureau = 'ianigla', path = path,
           file_name = 'ianigla_cuevas.csv',
           slot_name = c('tair', 'rh', 'patm',
                         'precip', 'wspd', 'wdir',
                         'kin', 'hsnow', 'tsoil'),
           by = 'hour',
           out_name = c('tair(°C)', 'rh(\%)', 'patm(mbar)',
                        'p(mm)', 'wspd(km/hr)', 'wdir(°)',
                        'kin(kW/m2)', 'hsnow(cm)', 'tsoil(°C)' )
          )

# subset relative humidity and plot it
hm_subset(obj = hm_cuevas, slot_name = 'rh',
          from = ISOdate(2020, 2, 1),
          to = ISOdate(2020, 4, 1) ) \%>\%
  hm_plot(slot_name = 'rh',
          col_name = list('rh(\%)'),
          interactive = TRUE,
          y_lab = 'RH(\%)' )
}

}
