% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/analyzeTS.R
\name{plotTS_comb}
\alias{plotTS_comb}
\title{Combine time seires plot together}
\usage{
plotTS_comb(..., nrow = 1, type = "line", list = NULL, x = "Date",
  y = "", title = "", output = FALSE)
}
\arguments{
\item{...}{different time series plots generated by \code{plotTS(, output = 'ggplot')}, refer to details.}

\item{nrow}{A number showing the number of rows.}

\item{type}{A string showing 'line' or 'bar'.}

\item{list}{If input is a list containing different ggplot data, use l\code{list = inputlist}.}

\item{x}{A string of x axis name.}

\item{y}{A string of y axis name.}

\item{title}{A string of the title.}

\item{output}{A boolean, if chosen TRUE, the output will be given.
NOTE: yOU HAVE TO PUT A \code{list = }, before your list.}
}
\value{
A combined time series plot.
}
\description{
Combine time seires plot together
}
\details{
..., representing different ouput file generated by \code{plotTS(, output = 'ggplot'), name = yourname},
different names must be assigned when generating different output.

e.g.
a1, a2, a3 are different files generated by \code{plotTS(, output = 'ggplot'), name = yourname}, you can
set \code{plotTS(a1,a2,a3)} or \code{plotTS(list = list(a1,a2,a3))}
}
\examples{
a1 <- plotTS(testdl[[1]], output = 'ggplot', name = 1)
a2 <- plotTS(testdl[[2]], output = 'ggplot', name = 2)

plotTS_comb(a1, a2)
plotTS_comb(list = list(a1, a2), y = 'y axis', nrow = 2)

# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}
\references{
\itemize{
\item H. Wickham. ggplot2: elegant graphics for data analysis. Springer New York, 2009.
}
}

