% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/components.R, R/colormap.R,
%   R/sidebar.R
\name{add_component}
\alias{add_component}
\alias{add_to_sidebar}
\alias{add_colormap}
\alias{add_link}
\alias{add_component,i2dashboard,character-method}
\alias{add_component,i2dashboard,function-method}
\alias{add_component,i2dashboard,gg-method}
\alias{add_component,i2dashboard,gt_tbl-method}
\alias{add_component,i2dashboard,kableExtra-method}
\alias{add_component,i2dashboard,Heatmap-method}
\alias{add_component,i2dashboard,ANY-method}
\alias{add_link,i2dashboard-method}
\alias{add_colormap,i2dashboard-method}
\alias{add_to_sidebar,i2dashboard,character-method}
\alias{add_to_sidebar,i2dashboard,function-method}
\title{Add content to an \linkS4class{i2dashboard} object.}
\usage{
add_component(dashboard, component, ...)

add_to_sidebar(dashboard, component, ...)

add_colormap(dashboard, ...)

add_link(dashboard, ...)

\S4method{add_component}{i2dashboard,character}(dashboard, component, page = "default", copy = FALSE, ...)

\S4method{add_component}{i2dashboard,`function`}(dashboard, component, page = "default", ...)

\S4method{add_component}{i2dashboard,gg}(dashboard, component, page = "default", ...)

\S4method{add_component}{i2dashboard,gt_tbl}(dashboard, component, page = "default", ...)

\S4method{add_component}{i2dashboard,kableExtra}(dashboard, component, page = "default", ...)

\S4method{add_component}{i2dashboard,Heatmap}(dashboard, component, page = "default", ...)

\S4method{add_component}{i2dashboard,ANY}(dashboard, component, page = "default", ...)

\S4method{add_link}{i2dashboard}(
  dashboard,
  href,
  title = NULL,
  icon = NULL,
  align = c("right", "left"),
  target = NULL
)

\S4method{add_colormap}{i2dashboard}(dashboard, map, name)

\S4method{add_to_sidebar}{i2dashboard,character}(
  dashboard,
  component,
  page = "default",
  global = FALSE,
  copy = FALSE,
  ...
)

\S4method{add_to_sidebar}{i2dashboard,`function`}(
  dashboard,
  component,
  page = "default",
  global = FALSE,
  copy = FALSE,
  ...
)
}
\arguments{
\item{dashboard}{A \linkS4class{i2dashboard}.}

\item{component}{An R object, function, or string.}

\item{...}{Additional parameters passed to the components render function. In case of an image, parameters \code{height} and \code{width} can be used to define the dimensions of the image with CSS or provide an alternative text with \code{image_alt_text}.}

\item{page}{The name of the page to add the component or sidebar to.}

\item{copy}{Whether or not to copy images to \code{dashboard@datadir}.}

\item{href}{The target of the link.}

\item{title}{The link title.}

\item{icon}{An optional link icon (see https://rmarkdown.rstudio.com/flexdashboard/using.html#icon-sets)}

\item{align}{Optional argument that can be “left” or “right” (defaults = “right”) defining the alignment of the links in the navigation bar}

\item{target}{An optional target (e.g. "_blank")}

\item{map}{A character vector containing colors and possible the levels they map to (as names).}

\item{name}{A name for the color mapping.}

\item{global}{Whether or not to add the content to the global sidebar.}
}
\value{
Returns the modified \linkS4class{i2dashboard} object.
\itemize{
  \item '\code{add_component()}' extends the list of components of the respective page, stored in the '\code{pages}' slot, by an R Markdown string containing the provided content.
  \item '\code{add_to_sidebar()}' extends either the '\code{sidebar}' slot or the '\code{sidebar}' entry of a single page by an R Markdown string containing the provided content.
  \item '\code{add_link()}' extends the '\code{navbar}' slot by a list of link properties.
  \item '\code{add_colormap()}' extends the '\code{colormaps}' slot by the new color mapping.
}
If something went wrong during the addition, the unmodified \linkS4class{i2dashboard} object is returned.
}
\description{
Content can be added to the dashboards pages, the sidebar or the navigation bar.
}
\details{
The options to add content in detail:
\itemize{
  \item \strong{'\code{add_component()}'} adds content to a page of the dashboard by evaluating a function, or by including an object, a text or image file.
  \item \strong{'\code{add_to_sidebar()}'} adds content to the dashboards global sidebar or to a pages local sidebar.
  \item \strong{'\code{add_link()}'} adds a link to the navigation bar.
  \item \strong{'\code{add_colormap()}'} adds a global color mapping to the dashboards colormaps.
}

The mechanism to add different types of content to a dashboards page or sidebar depends on the class of the object passed to the function '\code{add_component()}' or '\code{add_to_sidebar()}':

\itemize{
  \item A function will be evaluated and its return value is used as content.
  \item A string that ends with \code{.md} or \code{.txt} will be used to open a file and use its content.
  \item A string that ends with \code{\\.[png|jpg|jpeg|gif]} will be used to include an image as content.
  \item An R object (e.g. an 'htmlwidget') will be included if a suitable signature method is implemented.
}
}
\examples{
library(magrittr)
i2dashboard() -> dashboard
myFunction <- function(dashboard) paste0("### Generate component\n\n",
    "Lorem ipsum dolor sit amet\n")

dashboard \%<>\% add_component(component = myFunction)
dashboard \%<>\% add_component(component = plotly::plot_ly(mtcars, x=~wt, y=~hp),
    title = "Include htmlwidget")
\donttest{
  dashboard \%<>\% add_component(component = "sample.txt", title = "Include text")
  dashboard \%<>\% add_component(component = "sample.jpg", title = "Include image")
}

dashboard \%<>\% add_to_sidebar(component = myFunction)
\donttest{
  dashboard \%<>\% add_to_sidebar(component = "sample.txt", package="i2dash")
  dashboard \%<>\% add_to_sidebar(component = "sample.jpg", package="i2dash")
}

colors <- c("l1" = "#F7FCFD", "l2" ="#E5F5F9", "l3" = "#CCECE6")
dashboard \%<>\% add_colormap(map = colors, name = "test")

dashboard \%<>\% add_link(href = "www.sample_url.net", title = "MyLink", align = "left")
}
