% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_rolling_average.R
\name{add_rolling_average}
\alias{add_rolling_average}
\alias{add_rolling_average.default}
\alias{add_rolling_average.incidence2}
\title{Add a rolling average}
\usage{
add_rolling_average(x, ...)

\method{add_rolling_average}{default}(x, ...)

\method{add_rolling_average}{incidence2}(x, before = 2, ...)
}
\arguments{
\item{x}{An \link[incidence2:incidence]{incidence2::incidence} object.}

\item{...}{Not currently used.}

\item{before}{how many prior dates to group the current observation with.
Default is 2 days.}
}
\value{
An object of class \code{incidence2_rolling}.
}
\description{
\code{\link[=add_rolling_average]{add_rolling_average()}} adds a rolling average to an \code{\link[incidence2:incidence]{incidence2::incidence()}}
object.  If \code{x} is a grouped this will be a \code{\link[dplyr:rowwise]{dplyr::rowwise()}} type object.
If x is not grouped this will be a subclass of tibble.
}
\note{
If groups are present the average will be calculated across each
grouping, therefore care is required when plotting.
}
\examples{
if (requireNamespace("outbreaks", quietly = TRUE) &&
    requireNamespace("incidence2", quietly = TRUE)) {
  data(ebola_sim_clean, package = "outbreaks")
  dat <- ebola_sim_clean$linelist

  inci <- incidence2::incidence(dat,
                    date_index = date_of_onset,
                    interval = "week",
                    last_date = "2014-10-05",
                    groups = gender)

  ra <- add_rolling_average(inci, before = 2)
  plot(ra, color = "white")



  inci2 <- incidence2::regroup(inci)
  ra2 <- add_rolling_average(inci2, before = 2)
  plot(ra, color = "white")

}

}
