% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IARgsample}
\alias{IARgsample}
\title{Simulate from an IAR-Gamma Model}
\usage{
IARgsample(phi, st, n = 100L, sigma2 = 1L, mu = 1L)
}
\arguments{
\item{phi}{A coefficient of IAR-Gamma model. A value between 0 and 1.}

\item{st}{Array with observational times.}

\item{n}{Length of the output time series. A strictly positive integer.}

\item{sigma2}{Scale parameter of the IAR-Gamma process. A positive value.}

\item{mu}{Level parameter of the IAR-Gamma process. A positive value.}
}
\value{
A list with the following components:
\itemize{
\item{y}{ Array with simulated IAR-Gamma process.}
\item{st}{ Array with observation times.}
}
}
\description{
Simulates an IAR-Gamma Time Series Model.
}
\examples{
n=100
set.seed(6714)
st<-gentime(n)
y<-IARgsample(phi=0.9,st=st,n=n,sigma2=1,mu=1)
plot(st,y$y,type='l')
hist(y$y,breaks=20)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}
}
