% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F030.heatmap.gg.plot.R
\name{heatmap.gg.plot}
\alias{heatmap.gg.plot}
\title{Create heatmaps for genes in clusters or conditions.}
\usage{
heatmap.gg.plot(
  x = NULL,
  gene = "NULL",
  cell.sort = FALSE,
  data.type = "main",
  cluster.by = "clusters",
  min.scale = -2.5,
  max.scale = 2.5,
  interactive = TRUE,
  cex.col = 10,
  cex.row = 10,
  no.key = FALSE,
  out.name = "plot",
  heat.colors = c("blue", "white", "red")
)
}
\arguments{
\item{x}{A data frame containing gene counts for cells.}

\item{gene}{A set of gene names to be heatmapped.}

\item{cell.sort}{If FALSE the cells will not be sorted based on their distance, default = TRUE.}

\item{data.type}{Choose from "main" and "imputed", default = "main".}

\item{cluster.by}{Choose from "clusters", "conditions" or "none", default = "clusters".}

\item{min.scale}{Set a minimum color scale, default = -2.5.}

\item{max.scale}{Set a maximum color scale, default = 2.5.}

\item{interactive}{If TRUE an html interactive file will be made, default = TRUE.}

\item{cex.col}{Chhose a size, default = 10.}

\item{cex.row}{Choose a size, default = 10.}

\item{no.key}{If you want a color legend key, default = FALSE.}

\item{out.name}{Output name for html file if interactive = TRUE, default = "plot".}

\item{heat.colors}{Colors for heatmap, default = c("blue" ,"white", "red").}
}
\value{
An object of class iCellR
}
\description{
This function takes an object of class iCellR and genes and provides a heatmap.
}
\examples{
marker.genes <- findMarkers(demo.obj,fold.change = 2,padjval = 0.1,uniq = TRUE)

MyGenes <- top.markers(marker.genes, topde = 10, min.base.mean = 0.8)

heatmap.gg.plot(demo.obj,
               gene = MyGenes,
               out.name = "plot",
               cluster.by = "clusters",
               interactive = FALSE)
}
