% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F0028.R
\name{findMarkers}
\alias{findMarkers}
\title{Find marker genes for each cluster}
\usage{
findMarkers(
  x = NULL,
  data.type = "main",
  pval.test = "t.test",
  p.adjust.method = "hochberg",
  fold.change = 2,
  padjval = 0.1,
  Inf.FCs = FALSE,
  uniq = FALSE,
  positive = TRUE
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{data.type}{Choose from "main", "atac", "atac.imputed" and "imputed", default = "main"}

\item{pval.test}{Choose from "t.test", "wilcox.test", default = "t.test".}

\item{p.adjust.method}{Correction method. Choose from "holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none", default = "hochberg".}

\item{fold.change}{A number that designates the minimum fold change for out put, default = 2.}

\item{padjval}{Minimum adjusted p value for out put, default = 0.1.}

\item{Inf.FCs}{If set to FALSE the infinite fold changes would be filtered from out put, default = FALSE.}

\item{uniq}{If set to TRUE only genes that are a marker for only one cluster would be in the out put, default = FALSE.}

\item{positive}{If set to FALSE both the up regulated (positive) and down regulated (negative) markers would be in the out put, default = TRUE.}
}
\value{
An object of class iCellR
}
\description{
This function takes an object of class iCellR and performs differential expression (DE) analysis to find marker genes for each cluster.
}
