% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_start.R
\name{init_start}
\alias{init_start}
\title{Initialization of the start matrix}
\usage{
init_start(start, nns, ns = 0, soft_seeds = NULL, seeds = NULL, ...)
}
\arguments{
\item{start}{A matrix, character, or function. A \code{nns-by-nns} matrix, start
method like "bari", "convex" or "rds", or a function  to initialize the start matrix.
If a function, it must have at least the arguments nns, ns, and softs_seeds.}

\item{nns}{An integer. Number of non-seeds.}

\item{ns}{An integer. Number of seeds.}

\item{soft_seeds}{A vector, a matrix or a data frame indicating entries of the start matrix
that will be initialized at 1 to indicate . See \link{check_seeds}.}

\item{seeds}{A vector, a matrix or a data frame. Indicating hard seeds.
These are used for "convex" start but otherwise are ignored.}

\item{...}{Arguments passed to other start functions. See details in Values section.}
}
\value{
\code{init_start} returns a \code{nns-by-nns} doubly stochastic matrix as the start
matrix in the graph matching iteration. If conduct a soft seeding graph matching, returns a
\code{nns-by-nns} doubly stochastic matrix with 1's corresponding to the soft seeds and values
at the other places are derived by different start method.
}
\description{
Initialize the start matrix for graph matching iteration.
}
\details{
When \code{start} is a character, there are five options.
\itemize{
\item \code{"bari"} initializes at the barycenter.
\item \code{"rds_perm_bari"} gives a random linear combination of barycenter and
  a random permutation matrix, (1-a) B + a P. The argument \code{g} controls a
  with a being sampled as \code{g * runif()}.
\item \code{"rds"} gives a random doubly stochastic matrix. Users can specify a
  random deviates generator to the \code{distribution} argument, and the default is \code{runif}. 
  A random matrix with iid entries from \code{distribution} and the the Sinkhorn algorithm is applied
  to produce the output.
\item \code{"rds_from_sim"} gives a random doubly stochastic matrix derived from
  similarity scores. One needs to input a similarity score matrix to the \code{sim}
  argument for this method. The procedure is the same as \code{"rds"} but before 
  the Sinkhorn algorithm is applied, the entries of the random matrix are scaled by 
  \code{sim}.
\item \code{"convex"} returns the doubly stochastic matrix from the last iteration of running the Frank-
Wolfe algorithm with convex relaxation initialized at the barycenter. For this method, one needs to
input two graphs \code{A} and \code{B}, as well as \code{seeds} if applicable.
}
}
\examples{
ss <- matrix(c(5, 4, 4, 3), nrow = 2)
# initialize start matrix without soft seeds
init_start(start = "bari", nns = 5)
init_start(start = "rds", nns = 3)
init_start(start = "rds_perm_bari", nns = 5)
init_start(start = "rds_from_sim", nns = 3, sim = matrix(runif(9), 3))

# initialize start matrix with soft seeds
init_start(start = "bari", nns = 5, ns = 1, soft_seeds = ss)
init_start(start = "rds", nns = 5, soft_seeds = ss)
init_start(start = "rds_perm_bari", nns = 5, soft_seeds = ss)

\donttest{
# initialize start matrix for convex graph matching
cgnp_pair <- sample_correlated_gnp_pair(n = 10, corr =  0.3, p =  0.5)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2
seeds <- 1:10 <= 2
init_start(start = "convex", nns = 8, A = g1, B = g2, seeds = seeds)

# FW graph matching with incorrect seeds to start at convex start
init_start(start = "convex", nns = 8, ns = 2, soft_seeds = ss, A = g1, B = g2, seeds = seeds)
}

}
