/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.JohnsonSystem;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class JohnsonSUDist
extends JohnsonSystem {
    private static double calcR(double a, double b, double x) {
        double z = (x - a) / b;
        double s = Math.abs(z);
        if (s < 1.0E20) {
            s = Math.sqrt(z * z + 1.0);
        }
        double r = z >= 0.0 ? s + z : 1.0 / (s - z);
        return r;
    }

    public JohnsonSUDist(double gamma, double delta) {
        this(gamma, delta, 0.0, 1.0);
    }

    public JohnsonSUDist(double gamma, double delta, double xi, double lambda) {
        super(gamma, delta, xi, lambda);
    }

    public double density(double x) {
        return JohnsonSUDist.density(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    public double cdf(double x) {
        return JohnsonSUDist.cdf(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    public double barF(double x) {
        return JohnsonSUDist.barF(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    public double inverseF(double u) {
        return JohnsonSUDist.inverseF(this.gamma, this.delta, this.xi, this.lambda, u);
    }

    public double getMean() {
        return JohnsonSUDist.getMean(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getVariance() {
        return JohnsonSUDist.getVariance(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getStandardDeviation() {
        return JohnsonSUDist.getStandardDeviation(this.gamma, this.delta, this.xi, this.lambda);
    }

    public static double density(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double r = JohnsonSUDist.calcR(xi, lambda, x);
        if (r <= 0.0) {
            return 0.0;
        }
        double z = gamma + delta * Math.log(r);
        double y = (x - xi) / lambda;
        if (z >= 1.0E10) {
            return 0.0;
        }
        return delta / (lambda * Math.sqrt(Math.PI * 2) * Math.sqrt(y * y + 1.0)) * Math.exp(-z * z / 2.0);
    }

    public static double cdf(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double r = JohnsonSUDist.calcR(xi, lambda, x);
        if (r > 0.0) {
            return NormalDist.cdf01(gamma + delta * Math.log(r));
        }
        return 0.0;
    }

    public static double barF(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double r = JohnsonSUDist.calcR(xi, lambda, x);
        if (r > 0.0) {
            return NormalDist.barF01(gamma + delta * Math.log(r));
        }
        return 1.0;
    }

    public static double inverseF(double gamma, double delta, double xi, double lambda, double u) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double z = NormalDist.inverseF01(u);
        double v = (z - gamma) / delta;
        if (v >= 709.782712893384) {
            return Double.POSITIVE_INFINITY;
        }
        if (v <= -707.7032713517042) {
            return Double.NEGATIVE_INFINITY;
        }
        return xi + lambda * Math.sinh(v);
    }

    public static double getMean(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        return xi - lambda * Math.exp(1.0 / (2.0 * delta * delta)) * Math.sinh(gamma / delta);
    }

    public static double getVariance(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double omega2 = Math.exp(1.0 / (delta * delta));
        return (omega2 - 1.0) * (omega2 * Math.cosh(2.0 * gamma / delta) + 1.0) / 2.0 * lambda * lambda;
    }

    public static double getStandardDeviation(double gamma, double delta, double xi, double lambda) {
        return Math.sqrt(JohnsonSUDist.getVariance(gamma, delta, xi, lambda));
    }

    public void setParams(double gamma, double delta, double xi, double lambda) {
        this.setParams0(gamma, delta, xi, lambda);
    }
}

