% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMRMC.R
\name{sim.gRoeMetz}
\alias{sim.gRoeMetz}
\title{Simulate an MRMC data set of an ROC experiment comparing two modalities}
\usage{
sim.gRoeMetz(config)
}
\arguments{
\item{config}{[list] of simulation parameters:
\itemize{
  \item Experiment labels and size
  \itemize{
    \item modalityID.A: [character] label modality A
    \item modalityID.B: [character] label modality B
    \item nR: [numeric] number of readers
    \item nC.neg: [numeric] number of signal-absent cases
    \item nC.pos: [numeric] number of signal-present cases
  }
  \item There are six fixed effects:
  \itemize{
    \item mu.neg: [numeric] signal-absent (neg, global mean)
    \item mu.pos: [numeric] signal-present (pos, global mean)
    \item mu.Aneg: [numeric] modality A signal-absent (Aneg, modality effect)
    \item mu.Bneg: [numeric] modality B signal-absent (Bneg, modality effect)
    \item mu.Apos: [numeric] modality A signal-present (Apos, modality effect)
    \item mu.Bpos: [numeric] modality B signal-present (Bpos, modality effect)
  }
  \item There are six random effects that are independent of modality
  \itemize{
    \item var_r.neg: [numeric] variance of random reader effect
    \item var_c.neg: [numeric] variance of random case effect
    \item var_rc.neg: [numeric] variance of random reader by case effect
    \item var_r.pos: [numeric] variance of random reader effect
    \item var_c.pos: [numeric] variance of random case effect
    \item var_rc.pos: [numeric] variance of random reader by case effect
  }
  \item There are six random effects that are specific to modality A
    \itemize{
      \item var_r.Aneg: [numeric] variance of random reader effect
      \item var_c.Aneg: [numeric] variance of random case effect
      \item var_rc.Aneg: [numeric] variance of random reader by case effect
      \item var_r.Apos: [numeric] variance of random reader effect
      \item var_c.Apos: [numeric] variance of random case effect
      \item var_rc.Apos: [numeric] variance of randome reader by case effect
  }
  \item There are six random effects that are specific to modality B
    \itemize{
      \item var_r.Bneg: [numeric] variance of random reader effect
      \item var_c.Bneg: [numeric] variance of random case effect
      \item var_rc.Bneg: [numeric] variance of random reader by case effect
      \item var_r.Bpos: [numeric] variance of random reader effect
      \item var_c.Bpos: [numeric] variance of random case effect
      \item var_rc.Bpos: [numeric] variance of randome reader by case effect
  }
}}
}
\value{
dFrame.imrmc   [data.frame] with (nC.neg + nC.pos)*(nR+1) rows including
\itemize{
  \item readerID: [factor] w/ nR levels "reader1", "reader2", ...
  \item caseID: [factor] w/ nC levels "case1", "case2", ...
  \item modalityID: [factor] w/ 1 level config$modalityID
  \item score: [numeric] reader score
}

Note that the first nC.neg + nC.pos rows specify the truth labels for each case.
For these rows, the readerID must be "truth"
and the score must be 0 for negative cases and 1 for positive cases.
}
\description{
This procedure simulates an MRMC data set of an ROC experiment comparing two modalities.
It is based on Gallas2014_J-Med-Img_v1p031006, which generalizes of the model in
Roe1997_Acad-Radiol_v4p298 and Roe1997_Acad-Radiol_v4p587. Specifically, it allows
the variance components to depend on the truth and the modality. For the simpler
Roe and Metz model, you can enter the smaller set of parameters into
sim.gRoeMetz.config and it will return a larger set of parameters that can be used with this function.
}
\details{
The simulation is a linear model with six fixed effects related to
modality and truth and 18 normally distributed independent random effects
for readers, cases, and the interaction between the two. Here is the linear model:

L.mrct = mu.t + mu.mt \cr
       + reader.rt + case.ct + readerXcase.rct \cr
       + modalityXreader.mrt + modalityXcase.mct + modalityXreaderXcase.mrct \cr
\itemize{
  \item m=modality (levels: A and b)
  \item t=truth (levels: neg and Pos)
  \item mu.t is the global mean for t=neg and t=pos cases
  \item mu.mt is the modality specific fixed effects for t=neg and t=pos cases
  \item the remaining terms are the random effects: all independent normal random variables
}
}
