% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/EstIndex.R
\name{ChaoSpecies}
\alias{ChaoSpecies}
\title{Estimation of species richness}
\usage{
ChaoSpecies(x, datatype = "abundance", conf = 0.95)
}
\arguments{
\item{x}{a vector of species frequence}

\item{datatype}{the data type of input data. That is individual-based abundance data (\code{datatype = "abundance"}) or sample-based incidence data (\code{datatype = "incidence"}).}

\item{conf}{a positive number \eqn{\le} 1. "\code{conf}" specifies the confidence level for confidence interval. The default is \code{0.95}.}
}
\value{
a vector of species richness estimator and its confidence interval
}
\description{
\code{ChaoSpecies} Estimation of species richness via Chao (1984, 1987)
}
\examples{
data(spider)
ChaoSpecies(spider$Girdled, datatype="abundance")
}
\author{
K.H. Ma
}
\seealso{
\code{\link{ChaoEntropy}}
}

