% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{smart_read}
\alias{smart_read}
\title{Read a data file}
\usage{
smart_read(
  file,
  ext = tools::file_ext(file),
  preview = FALSE,
  column_types = NULL,
  ...
)
}
\arguments{
\item{file}{the file path to read}

\item{ext}{file extension, namely "csv" or "txt"}

\item{preview}{logical, if \code{TRUE} only the first few rows of
the data will be returned}

\item{column_types}{vector of column types (see ?readr::read_csv)}

\item{...}{additional parameters passed to read_* functions}
}
\value{
A dataframe with some additional attributes:
\itemize{
\item \code{name} is the name of the file
\item \code{code} contains the \link[tidyverse]{tidyverse} code used to read the data
\item \code{sheets} contains names of sheets if 'file' is an Excel file (can be retrieved using the \code{sheets()} helper function)
}
}
\description{
A simple function that imports a file without the users needing to
specify information about the file type (see Details for more).
The \code{smart_read()} function uses the file's extension to determine
the appropriate function to read the data.
Additionally, characters are converted to factors by default,
mostly for compatibility with iNZight (https://inzight.nz).
}
\details{
Currently, \code{smart_read()} understands the following file types:
\itemize{
\item delimited (.csv, .txt)
\item Excel (.xls, .xlsx)
\item SPSS (.sav)
\item Stata (.dta)
\item SAS (.sas7bdat, .xpt)
\item R data (.rds)
\item JSON (.json)
}
}
\author{
Tom Elliott
}
