% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_summarize_png_data.R
\name{ifcb_summarize_png_data}
\alias{ifcb_summarize_png_data}
\title{Summarize Image Counts by Class and Sample}
\usage{
ifcb_summarize_png_data(
  png_folder,
  hdr_folder = NULL,
  sum_level = "sample",
  verbose = TRUE
)
}
\arguments{
\item{png_folder}{A character string specifying the path to the main directory containing subfolders (classes) with .png images.}

\item{hdr_folder}{A character string specifying the path to the directory containing the .hdr files. Default is NULL.}

\item{sum_level}{A character string specifying the level of summarization. Options: "sample" (default) or "class".}

\item{verbose}{A logical indicating whether to print progress messages. Default is TRUE.}
}
\value{
If sum_level is "sample", returns a data frame with columns: sample, ifcb_number, class_name, n_images, gpsLatitude, gpsLongitude, timestamp, year, month, day, time, roi_numbers.
If sum_level is "class", returns a data frame with columns: class_name, n_images.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function was deprecated as it has been replaced by a function with a more accurate
name: \code{ifcb_summarize_png_counts}.

This function summarizes the number of images per class for each sample and timestamps,
and optionally retrieves GPS positions, and IFCB information using \code{ifcb_read_hdr_data} and \code{ifcb_convert_filenames} functions.
}
\examples{
\dontrun{
# Example usage:
# Assuming the following directory structure:
# path/to/png_folder/
# |- class1/
# |  |- sample1_00001.png
# |  |- sample1_00002.png
# |  |- sample2_00001.png
# |- class2/
# |  |- sample1_00003.png
# |  |- sample3_00001.png

png_folder <- "path/to/png_folder"
hdr_folder <- "path/to/hdr_folder" # This folder should contain corresponding .hdr files

# Summarize by sample
summary_sample <- ifcb_summarize_png_data(png_folder,
                                          hdr_folder,
                                          sum_level = "sample",
                                          verbose = TRUE)
print(summary_sample)

# Summarize by class
summary_class <- ifcb_summarize_png_data(png_folder,
                                         hdr_folder,
                                         sum_level = "class",
                                         verbose = TRUE)
print(summary_class)
}
}
\seealso{
\code{\link{ifcb_read_hdr_data}} \code{\link{ifcb_convert_filenames}}
}
\keyword{internal}
