% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{run.bootstraps}
\alias{run.bootstraps}
\title{Bootstrapping procedure}
\usage{
run.bootstraps(config_matrices, nboots = 1000)
}
\arguments{
\item{config_matrices}{The result from compute.config.matrices().}

\item{nboots}{The number of bootstraps to perform (default=1000).}
}
\value{
An n x n x nboots array of RV coefficients for the bootstrapped data, where n is the number of datasets.
}
\description{
Performs a bootstrapping procedure. The result from this function can be used with
rv.conf.interval() to determine confidence intervals. By decoupling this into two functions,
you don't have to redo the bootstrapping for every confidence interval, hence increasing the runtime speed.
}
\examples{
set.seed(2)
n = 100
p = 100
x1 = matrix(rnorm(n*p), n, p)
x2 = x1 + matrix(rnorm(n*p), n, p)
x3 = x2 + matrix(rnorm(n*p), n, p)
data = list(x1=x1, x2=x2, x3=x3)
config_matrices = compute.config.matrices(data)
cors_boot = run.bootstraps(config_matrices, nboots=1000)
rv.conf.interval(cors_boot, "x1", "x3", "x2")
}
