% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAIndex.R
\name{SAIndex}
\alias{SAIndex}
\title{Estimate Index and Preindex of Storm Activity}
\usage{
SAIndex(data, coord, wf = "la8")
}
\arguments{
\item{data}{a matrix or a data frame of H-component values. Each column should contain records from an individual station.}

\item{coord}{a matrix of colatitude and longitude of each station used in a study}

\item{wf}{type of wavelet filter used to separate magnetic storm activity from the solar quiet variation. LA(8) filter is the default.}
}
\value{
SI the index of global storm activity, WISA

p.SQ the preindex of the storm activity constructed using wavelet-based MRA. It is the contribution of a station to the storm signature.
}
\description{
Function to estimate index of global storm activity, WISA (wavelet index of storm activity), and values of storm activity preindex of individual stations Hermanus (HER), station KAkioka (KAK), station Honolulu (HON) and station San Juan (SJG). The WISA can be constructed practically over any period of time, but to obtain values similar to the standard Dst, at least 2 months worth of data are needed.
}
\details{
\code{SAIndex} is a function for estimating the index of magnetic storm activity. The function returns the index of global storm activity as well as the preindex for each of the individual stations used.
}
\examples{
\dontrun{
## data sets.
data(record)
## Colatitude and longitude of geomagnetic observatories.
coord=matrix(c(124.43, 19.23, 53.77,140.18,68.68,202.00,71.89,293.85),nrow=2,ncol=4)


## estimate WISA and preindex for each stations.
index.sample<- SAIndex(record, coord, wf="la8")

## plot SI
start.date="2001-3-1"
end.date="2001-4-30"
n.station=4
station.names=c("HER","KAK","HON","SJG")


SIplot(index.sample$SI, type=1,start=start.date, end=end.date, 
main="WISA estimation", xlab="Datetime", ylab="iWISA Estimation")
}

}
\author{
Inga Maslova

Wen Xiao
}
\references{
Jach,A., P.Kokoszka, J.Sojka, and L.Zhu(2006),Wavelet-based index of magnetic storm activity, J. Geophys. Res.,111, A09215, doi:10.1029/2006JA011635.

Maslova, I.,P.Kokoszka, J.Sojka, and L. Zhu(2009),Removal of nonconstant daily variation by means of wavelet and functional data analysis, J. Geophys. Res.,114, A03202, doi:10.1029/2008JA013685.
}
\seealso{
\code{\link{magnetic.latitude}}, \code{\link{SIplot}}, \code{\link{preindexplot}}
}

