% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaitrees.R
\name{set_threshold}
\alias{set_threshold}
\title{For a binary classification problem, update the the predicted labels in the
leaves of the learner to predict a label only if the predicted probability is
at least the specified threshold.}
\usage{
set_threshold(lnr, label, threshold, ...)
}
\arguments{
\item{lnr}{The learner to modify.}

\item{label}{The referenced label.}

\item{threshold}{The probability threshold above which \code{label} will be
be predicted.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v2.0.0/IAITrees/reference/#IAI.set_threshold!}{\code{IAI.set_threshold!}}
}
\examples{
\dontrun{iai::set_threshold(lnr, "A", 0.4)}

}
